/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.requests.FormattedRequestData;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.UnsupportedEncodingException;

public class EssStorageDataRequestBody
extends XFrameRsfRequestBody
implements FormattedRequestData {
    private static final String TRACE_MASKT = "XRSFMM T";
    private static final String TRACE_MASKF = "XRSFMM F";
    private static final String TRACE_MASKD = "XRSFMM D";
    private static String blanks = "                                ";
    private static String EBCDIC = "Cp500";
    private static int neg = -256;
    private static byte[] nulls = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static String nullBytes = new String(nulls);
    private static char nullByte = nullBytes.charAt(0);
    private static int REMAINDER = 272;
    public static String ESS_FILENAME = "Filename";

    public EssStorageDataRequestBody() {
    }

    public EssStorageDataRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        return result;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String filename = this.getAttribute(ESS_FILENAME);
        if (filename == null || filename.length() == 0) {
            this.invalidMessage = "Filename is undefined in attribute list";
            return false;
        }
        return true;
    }

    public String buildData() {
        StringBuffer data = new StringBuffer(blanks.substring(0, 31));
        String headerString = nullBytes.substring(0, 2) + "  ";
        data.append(nullBytes.substring(0, 2));
        data.append(headerString);
        data.append("05");
        data.append(headerString);
        data.append("01");
        String dateString = headerString + "00000000";
        int i = 0;
        while (i < 5) {
            data.append(dateString);
            ++i;
        }
        data.append(headerString);
        byte[] fc = new byte[]{0, 1};
        try {
            data.append(new String(fc, EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute(ESS_FILENAME), 64));
        data.append(nullBytes.substring(0, REMAINDER));
        String stringData = data.toString();
        int printLength = stringData.length() - REMAINDER;
        try {
            Trace.trace(TRACE_MASKD, "Data:\n" + RsfHexadecimal.buildHexadecimalString(stringData.getBytes(EBCDIC), 0, printLength) + "\n" + stringData.substring(0, printLength));
        }
        catch (Exception e) {}
        return stringData;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        return buffer.toString();
    }

    private static byte assignByte(int i) {
        if (i <= 127) {
            return (byte)i;
        }
        return (byte)(i | neg);
    }

    private static byte[] calcLength(int length) {
        byte[] byteLength = new byte[]{(byte)(length / 256), (byte)(length % 256)};
        return byteLength;
    }

    static {
        blanks = blanks + blanks + blanks + blanks + blanks + blanks;
        nullBytes = nullBytes + nullBytes + nullBytes + nullBytes;
        nullBytes = nullBytes + nullBytes + nullBytes + nullBytes;
        nullBytes = nullBytes + nullBytes + nullBytes + nullBytes;
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

